/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.jei.MekanismJEI;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.client.jei.interfaces.IJEIRecipeArea;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;

public class GuiElementHandler
implements IGuiContainerHandler<GuiMekanism<?>> {
    private static boolean areaSticksOut(int x, int y, int width, int height, int parentX, int parentY, int parentWidth, int parentHeight) {
        return x < parentX || y < parentY || x + width > parentX + parentWidth || y + height > parentY + parentHeight;
    }

    public static List<Rect2i> getAreasFor(int parentX, int parentY, int parentWidth, int parentHeight, Collection<? extends GuiEventListener> children) {
        ArrayList<Rect2i> areas = new ArrayList<Rect2i>();
        for (GuiEventListener guiEventListener : children) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (!widget.f_93624_) continue;
            if (GuiElementHandler.areaSticksOut(widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_(), parentX, parentY, parentWidth, parentHeight)) {
                areas.add(new Rect2i(widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_()));
            }
            if (!(widget instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)widget;
            for (Rect2i grandChildArea : GuiElementHandler.getAreasFor(widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_(), element.children())) {
                if (!GuiElementHandler.areaSticksOut(grandChildArea.m_110085_(), grandChildArea.m_110086_(), grandChildArea.m_110090_(), grandChildArea.m_110091_(), parentX, parentY, parentWidth, parentHeight)) continue;
                areas.add(grandChildArea);
            }
        }
        return areas;
    }

    public List<Rect2i> getGuiExtraAreas(GuiMekanism<?> gui) {
        int parentX = gui.getLeft();
        int parentY = gui.getTop();
        int parentWidth = gui.getWidth();
        int parentHeight = gui.getHeight();
        List<Rect2i> extraAreas = GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, gui.m_6702_());
        extraAreas.addAll(GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, gui.getWindows()));
        return extraAreas;
    }

    @Nullable
    public Object getIngredientUnderMouse(GuiMekanism<?> gui, double mouseX, double mouseY) {
        GuiWindow guiWindow = gui.getWindowHovering(mouseX, mouseY);
        return this.getIngredientUnderMouse(guiWindow == null ? gui.m_6702_() : guiWindow.children(), mouseX, mouseY);
    }

    @Nullable
    private Object getIngredientUnderMouse(List<? extends GuiEventListener> children, double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : children) {
            if (guiEventListener instanceof AbstractWidget) {
                GuiElement element;
                Object underGrandChild;
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                if (!widget.f_93624_) continue;
                if (widget instanceof GuiElement && (underGrandChild = this.getIngredientUnderMouse((element = (GuiElement)widget).children(), mouseX, mouseY)) != null) {
                    return underGrandChild;
                }
            }
            if (!(guiEventListener instanceof IJEIIngredientHelper)) continue;
            IJEIIngredientHelper helper = (IJEIIngredientHelper)guiEventListener;
            if (!guiEventListener.m_5953_(mouseX, mouseY)) continue;
            return helper.getIngredient(mouseX, mouseY);
        }
        return null;
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(GuiMekanism<?> gui, double mouseX, double mouseY) {
        GuiWindow guiWindow = gui.getWindowHovering(mouseX += (double)gui.getGuiLeft(), mouseY += (double)gui.getGuiTop());
        if (guiWindow == null) {
            return this.getGuiClickableArea(gui.m_6702_(), mouseX, mouseY);
        }
        return this.getGuiClickableArea(guiWindow.children(), mouseX, mouseY);
    }

    private Collection<IGuiClickableArea> getGuiClickableArea(List<? extends GuiEventListener> children, double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : children) {
            MekanismJEIRecipeType<?>[] categories;
            IJEIRecipeArea recipeArea;
            if (!(guiEventListener instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)guiEventListener;
            if (!element.f_93624_) continue;
            Collection<IGuiClickableArea> clickableGrandChildAreas = this.getGuiClickableArea(element.children(), mouseX, mouseY);
            if (!clickableGrandChildAreas.isEmpty()) {
                return clickableGrandChildAreas;
            }
            if (!(element instanceof IJEIRecipeArea) || !(recipeArea = (IJEIRecipeArea)((Object)element)).isJEIAreaActive() || (categories = recipeArea.getRecipeCategories()) == null || !recipeArea.isMouseOverJEIArea(mouseX, mouseY)) continue;
            IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)element.getRelativeX(), (int)element.getRelativeY(), (int)element.m_5711_(), (int)element.m_93694_(), MekanismJEI.recipeType(categories));
            return Collections.singleton(clickableArea);
        }
        return Collections.emptyList();
    }
}

